<?php
/**
 * Class For BackWPup Jobs page
 */
class BackWPup_Page_Jobs extends WP_List_Table {

	private static $listtable = NULL;
	public static $logfile = NULL;
	private $job_object = NULL;
	private $job_types = NULL;
	private $destinations = NULL;


	/**
	 *
	 */
	function __construct() {
		parent::__construct( array(
								  'plural'   => 'jobs',
								  'singular' => 'job',
								  'ajax'     => TRUE
							 ) );
	}


	/**
	 * @return bool|void
	 */
	function ajax_user_can() {

		return current_user_can( 'backwpup' );
	}

	/**
	 *
	 */
	function prepare_items() {

		$this->items = BackWPup_Option::get_job_ids();

		$this->job_object = BackWPup_Job::get_working_data();

		$this->job_types    = BackWPup::get_job_types();
		$this->destinations = BackWPup::get_registered_destinations();
	}

	/**
	 *
	 */
	function no_items() {

		_e( 'No Jobs.', 'backwpup' );
	}

	/**
	 * @return array
	 */
	function get_bulk_actions() {

		if ( ! $this->has_items() )
			return array ();

		$actions             = array();
		$actions[ 'delete' ] = __( 'Delete', 'backwpup' );

		return apply_filters( 'backwpup_page_jobs_get_bulk_actions', $actions );
	}

	/**
	 * @return array
	 */
	function get_columns() {

		$jobs_columns              = array();
		$jobs_columns[ 'cb' ]      = '<input type="checkbox" />';
		$jobs_columns[ 'jobname' ] = __( 'Job Name', 'backwpup' );
		$jobs_columns[ 'type' ]    = __( 'Type', 'backwpup' );
		$jobs_columns[ 'dest' ]    = __( 'Destinations', 'backwpup' );
		$jobs_columns[ 'next' ]    = __( 'Next Run', 'backwpup' );
		$jobs_columns[ 'last' ]    = __( 'Last Run', 'backwpup' );

		return $jobs_columns;
	}

	/**
	 * The cb Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_cb( $item ) {

		return '<input type="checkbox" name="jobs[]" value="' . esc_attr( $item ) . '" />';
	}

	/**
	 * The jobname Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_jobname( $item ) {

		$job_normal_hide ='';
		if ( is_object( $this->job_object ) )
			$job_normal_hide = ' style="display:none;"';

		$r = '<strong title="' . sprintf( __( 'Job ID: %d', 'backwpup' ), $item ) . '">' . esc_html( BackWPup_Option::get( $item, 'name' ) ) . '</strong>';
		$actions = array();
		if ( current_user_can( 'backwpup_jobs_edit' ) ) {
			$actions[ 'edit' ]     = "<a href=\"" . wp_nonce_url( network_admin_url( 'admin.php' ) . '?page=backwpupeditjob&jobid=' . $item, 'edit-job' ) . "\">" . __( 'Edit', 'backwpup' ) . "</a>";
			$actions[ 'copy' ]     = "<a href=\"" . wp_nonce_url( network_admin_url( 'admin.php' ) . '?page=backwpupjobs&action=copy&jobid=' . $item, 'copy-job_' . $item ) . "\">" . __( 'Copy', 'backwpup' ) . "</a>";
			$actions[ 'delete' ]   = "<a class=\"submitdelete\" href=\"" . wp_nonce_url( network_admin_url( 'admin.php' ) . '?page=backwpupjobs&action=delete&jobs[]=' . $item, 'bulk-jobs' ) . "\" onclick=\"return showNotice.warn();\">" . __( 'Delete', 'backwpup' ) . "</a>";
		}
		if ( current_user_can( 'backwpup_jobs_start' ) ) {
			$url                   = BackWPup_Job::get_jobrun_url( 'runnowlink', $item );
			$actions[ 'runnow' ]   = "<a href=\"" . $url[ 'url' ] . "\">" . __( 'Run now', 'backwpup' ) . "</a>";
		}
		if ( current_user_can( 'backwpup_logs' ) && BackWPup_Option::get( $item, 'logfile' ) ) {
			$logfile = basename( BackWPup_Option::get( $item, 'logfile' ) );
			if ( is_object( $this->job_object ) && $this->job_object->job[ 'jobid' ] == $item )
				$logfile = basename( $this->job_object->logfile );
			$actions[ 'lastlog' ]   = '<a href="' . admin_url( 'admin-ajax.php' ) . '?&action=backwpup_view_log&logfile=' . $logfile .'&_ajax_nonce=' . wp_create_nonce( 'view-logs' ) . '&amp;TB_iframe=true&amp;width=640&amp;height=440\" title="' . esc_attr( $logfile ) . '" class="thickbox">' . __( 'Last log', 'backwpup' ) . '</a>';
		}
		$actions = apply_filters( 'backwpup_page_jobs_actions', $actions, $item, FALSE );
		$r .= '<div class="job-normal"' . $job_normal_hide . '>' . $this->row_actions( $actions ) . '</div>';
		if ( is_object( $this->job_object ) ) {
			$actionsrun = array();
			$actionsrun = apply_filters( 'backwpup_page_jobs_actions', $actionsrun, $item, TRUE );
			$r .= '<div class="job-run">' . $this->row_actions( $actionsrun ) . '</div>';
		}

		return $r;
	}

	/**
	 * The type Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_type( $item ) {

		$r = '';
		if ( $types = BackWPup_Option::get( $item, 'type' ) ) {
			foreach ( $types as $type ) {
				if ( isset( $this->job_types[ $type ] ) ) {
					$r .= $this->job_types[ $type ]->info[ 'name' ] . '<br />';
				}
				else {
					$r .= $type . '<br />';
				}
			}
		}

		return $r;
	}

	/**
	 * The destination Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_dest( $item ) {

		$r = '';
		$backup_to = FALSE;
		foreach ( BackWPup_Option::get( $item, 'type' ) as $typeid ) {
			if ( isset( $this->job_types[ $typeid ] ) && $this->job_types[ $typeid ]->creates_file() ) {
				$backup_to = TRUE;
				break;
			}
		}
		if ( $backup_to ) {
			foreach ( BackWPup_Option::get( $item, 'destinations' ) as $destid ) {
				if ( isset( $this->destinations[ $destid ][ 'info' ][ 'name' ] ) ) {
					$r .= $this->destinations[ $destid ][ 'info' ][ 'name' ] . '<br />';
				} else {
					$r .= $destid . '<br />';
				}
			}
		}
		else {
			$r .= '<i>' . __( 'Not needed or set', 'backwpup' ) . '</i><br />';
		}

		return $r;
	}

	/**
	 * The next Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_next( $item ) {

		$r = '';

		$job_normal_hide ='';
		if ( is_object( $this->job_object ) )
			$job_normal_hide = ' style="display:none;"';

		if ( is_object( $this->job_object ) && $this->job_object->job[ 'jobid' ] == $item ) {
			$runtime = current_time( 'timestamp' ) - $this->job_object->start_time;
			$r .= '<div class="job-run">' . sprintf( __( 'Running for: %s seconds', 'backwpup' ), '<span id="runtime">' . $runtime . '</span>' ) .'</div>';
		}
		if ( is_object( $this->job_object ) && $this->job_object->job[ 'jobid' ] == $item )
			$r .='<div class="job-normal"' . $job_normal_hide . '>';
		if ( BackWPup_Option::get( $item, 'activetype' ) == 'wpcron' ) {
			if ( $nextrun = wp_next_scheduled( 'backwpup_cron', array( 'id' => $item ) ) + ( get_option( 'gmt_offset' ) * 3600 )  )
				$r .= '<span title="' . sprintf( __( 'Cron: %s','backwpup'),BackWPup_Option::get( $item, 'cron' ) ). '">' . sprintf( __( '%1$s at %2$s by WP-Cron', 'backwpup' ) , date_i18n( get_option( 'date_format' ), $nextrun, TRUE ) , date_i18n( get_option( 'time_format' ), $nextrun, TRUE ) ) . '</span>';
			else
				$r .= __( 'Not scheduled!', 'backwpup' );
		}
		else {
			$r .= __( 'Inactive', 'backwpup' );
		}
		if ( is_object( $this->job_object ) && $this->job_object->job[ 'jobid' ] == $item )
			$r .= '</div>';

		return $r;
	}

	/**
	 * The last Column
	 *
	 * @param $item
	 * @return string
	 */
	function column_last( $item ) {

		$r = '';

		if ( BackWPup_Option::get( $item, 'lastrun' ) ) {
			$lastrun = BackWPup_Option::get( $item, 'lastrun' );
			$r .= sprintf( __( '%1$s at %2$s', 'backwpup' ), date_i18n( get_option( 'date_format' ), $lastrun, TRUE ), date_i18n( get_option( 'time_format' ), $lastrun, TRUE ) );
			if ( BackWPup_Option::get( $item, 'lastruntime' ) )
				$r .= '<br />' . sprintf( __( 'Runtime: %d seconds', 'backwpup' ), BackWPup_Option::get( $item, 'lastruntime' ) );
		}
		else {
			$r .= __( 'not yet', 'backwpup' );
		}
		$r .= "<br /><span class=\"last-action-links\">";
		if ( current_user_can( 'backwpup_backups_download' ) && BackWPup_Option::get( $item, 'lastbackupdownloadurl' ) )
			$r .= "<a  href=\"" . wp_nonce_url( BackWPup_Option::get( $item, 'lastbackupdownloadurl' ), 'download-backup' ) . "\" title=\"" . esc_attr( __( 'Download last backup', 'backwpup' ) ) . "\">" . __( 'Download', 'backwpup' ) . "</a> | ";
		if ( current_user_can( 'backwpup_logs' ) && BackWPup_Option::get( $item, 'logfile' ) ) {
			$logfile = basename( BackWPup_Option::get( $item, 'logfile' ) );
			if ( is_object( $this->job_object ) && $this->job_object->job[ 'jobid' ] == $item )
				$logfile = basename( $this->job_object->logfile );
			$r .= '<a class="thickbox" href="' . admin_url( 'admin-ajax.php' ) . '?&action=backwpup_view_log&logfile=' . $logfile .'&_ajax_nonce=' . wp_create_nonce( 'view-logs' ) . '&amp;TB_iframe=true&amp;width=640&amp;height=440" title="' . esc_attr( $logfile ) . '">' . __( 'Log', 'backwpup' ) . '</a>';

		}
		$r .= "</span>";

		return $r;
	}


	/**
	 *
	 */
	public static function load() {

		//Create Table
		self::$listtable = new self;

		switch ( self::$listtable->current_action() ) {
			case 'delete': //Delete Job
				if ( ! current_user_can( 'backwpup_jobs_edit' ) )
					break;
				if ( is_array( $_GET[ 'jobs' ] ) ) {
					check_admin_referer( 'bulk-jobs' );
					foreach ( $_GET[ 'jobs' ] as $jobid ) {
						wp_clear_scheduled_hook( 'backwpup_cron', array( 'id' => $jobid ) );
						BackWPup_Option::delete_job( $jobid );
					}
				}
				break;
			case 'copy': //Copy Job
				if ( ! current_user_can( 'backwpup_jobs_edit' ) )
					break;
				$old_job_id = (int)$_GET[ 'jobid' ];
				check_admin_referer( 'copy-job_' . $_GET[ 'jobid' ] );
				//create new
				$newjobid = BackWPup_Option::get_job_ids();
				sort( $newjobid );
				$newjobid    = end( $newjobid ) + 1;
				$old_options = BackWPup_Option::get_job( $old_job_id );
				foreach ( $old_options as $key => $option ) {
					if ( $key == "jobid" )
						$option = $newjobid;
					if ( $key == "name" )
						$option = __( 'Copy of', 'backwpup' ) . ' ' . $option;
					if ( $key == "activetype" )
						$option = '';
					if ( $key == "archivename" )
						$option = str_replace( $_GET[ 'jobid' ], $newjobid, $option );
					if ( $key == "logfile" || $key == "lastbackupdownloadurl" || $key == "lastruntime" ||
						$key == "lastrun" )
						continue;
					BackWPup_Option::update( $newjobid, $key, $option );
				}
				break;
			case 'start_cli': //Get cmd start file
				if ( ! current_user_can( 'backwpup_jobs_start' ) )
					break;
				check_admin_referer( 'start_cli' );
				if ( empty( $_GET[ 'jobid' ] ) )
					break;
				if ( FALSE === strpos( PHP_OS, "WIN" ) ) {
					header( "Pragma: public" );
					header( "Expires: 0" );
					header( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
					header( "Content-Type: application/octet-stream" );
					header( "Content-Disposition: attachment; filename=BackWPup_cmd_start_job_" . $_GET[ 'jobid' ] . ".sh;" );
					if ( defined( 'PHP_BINDIR' ) )
						echo "#!/bin/sh" . PHP_EOL;
					echo "@\$1php -c \"" . php_ini_loaded_file() . "\" -r \"\$_SERVER[ 'SERVER_ADDR' ] = '". $_SERVER[ 'SERVER_ADDR' ] ."'; \$_SERVER[ 'REMOTE_ADDR' ] = '". $_SERVER[ 'REMOTE_ADDR' ] ."'; \$_SERVER[ 'HTTP_HOST' ] = '". $_SERVER[ 'HTTP_HOST' ] ."'; \$_SERVER[ 'HTTP_USER_AGENT' ] = '". BackWPup::get_plugin_data( 'name' ) ."'; define( 'DOING_CRON', TRUE ); require '" . ABSPATH . "wp-load.php'; if( class_exists( 'BackWPup_Job' ) ) BackWPup_Job::start_cli( " . $_GET[ 'jobid' ] . " );\"";
					die();
				}
				else {
					header( "Pragma: public" );
					header( "Expires: 0" );
					header( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
					header( "Content-Type: application/octet-stream" );
					header( "Content-Disposition: attachment; filename=BackWPup_cmd_start_job_" . $_GET[ 'jobid' ] . ".cmd;" );
					echo "@%1php.exe -c \"" . php_ini_loaded_file() . "\" -r \"\$_SERVER[ 'SERVER_ADDR' ] = '". $_SERVER[ 'SERVER_ADDR' ] ."'; \$_SERVER[ 'REMOTE_ADDR' ] = '". $_SERVER[ 'REMOTE_ADDR' ] ."'; \$_SERVER[ 'HTTP_HOST' ] = '". $_SERVER[ 'HTTP_HOST' ] ."'; \$_SERVER[ 'HTTP_USER_AGENT' ] = '". BackWPup::get_plugin_data( 'name' ) ."'; define( 'DOING_CRON', TRUE ); require '" . ABSPATH . "wp-load.php'; if( class_exists( 'BackWPup_Job' ) ) BackWPup_Job::start_cli( " . $_GET[ 'jobid' ] . " );\"";
					die();
				}
				break;
			case 'runnow':
				if ( ! empty( $_GET[ 'jobid' ] ) ) {
					if ( ! current_user_can( 'backwpup_jobs_start' ) )
						wp_die( __( 'Sorry, you don\'t have permissions to do that.', 'backwpup') );
					check_admin_referer( 'backwpup_job_run-runnowlink' );

					//check temp folder
					BackWPup_Job::check_folder( BackWPup::get_plugin_data( 'TEMP' ) );
					//check log folder
					BackWPup_Job::check_folder( get_site_option( 'backwpup_cfg_logfolder' ) );
					//check server callback
					$raw_response = BackWPup_Job::get_jobrun_url( 'test' );
					$test_result = '';
					if ( is_wp_error( $raw_response ) )
						$test_result .= sprintf( __( 'The HTTP response test get an error "%s"','backwpup' ), $raw_response->get_error_message() );
					elseif ( 200 != wp_remote_retrieve_response_code( $raw_response ) && 204 != wp_remote_retrieve_response_code( $raw_response ) )
						$test_result .= sprintf( __( 'The HTTP response test get a false http status (%s)','backwpup' ), wp_remote_retrieve_response_code( $raw_response ) );
					if ( ! empty( $test_result ) )
						BackWPup_Admin::message( $test_result, TRUE );

					//only start job if messages empty
					$log_messages = BackWPup_Admin::get_messages();
					if ( empty ( $log_messages ) )  {
						BackWPup_Admin::message( sprintf( __( 'Job "%s" started.', 'backwpup' ), esc_attr( BackWPup_Option::get( $_GET[ 'jobid' ], 'name' ) ) ) );
						BackWPup_Job::get_jobrun_url( 'runnow', $_GET[ 'jobid' ] );
						usleep( 250000 ); //wait a quarter second
						//sleep as long as job not started
						$i=0;
						$job_object = BackWPup_Job::get_working_data();
						while ( ! is_object( $job_object ) && empty( $job_object->logfile ) ) {
							usleep( 250000 ); //wait a quarter second for next try
							clearstatcache();
							$job_object = BackWPup_Job::get_working_data();
							//wait maximal 10 sec.
							if ( $i >= 40 )
								break;
							$i++;
						}
					}
				}
				break;
			case 'abort': //Abort Job
				if ( ! current_user_can( 'backwpup_jobs_start' ) )
					break;
				check_admin_referer( 'abort-job' );
				if ( ! file_exists( BackWPup::get_plugin_data( 'running_file' ) ) )
					break;
				//abort
				BackWPup_Job::user_abort();
				BackWPup_Admin::message( __( 'Job will be terminated.', 'backwpup' ) ) ;
				break;
			default:
				do_action( 'backwpup_page_jobs_load', self::$listtable->current_action() );
				break;
		}

		self::$listtable->prepare_items();
	}

	/**
	 *
	 */
	public static function admin_print_styles() {

		?>
		<style type="text/css" media="screen">

			.column-last, .column-next, .column-type, .column-dest {
				width: 15%;
			}

			#TB_ajaxContent {
				background-color: black;
				color: white;
			}

			#showworking {
				white-space: pre;
				display: block;
				width: 100%;
			}
			#runningjob {
				padding:10px;
				position:relative;
				margin: 15px 0 25px 0;
				padding-bottom:25px;
			}
			h2#runnigtitle {
				margin-bottom: 15px;
				padding: 0;
			}
			#warningsid, #errorid {
				margin-right: 10px;
			}

			.infobuttons {
				position: absolute;
				right: 10px;
				bottom: 0;
			}
/*
			a#showworkingbutton {
				float: left;
				padding: 10px;
				font-size: 12px;
				font-family: sans-serif,"Arial";
				text-decoration :none;
				background-color: #93b509;
				color: #fff;
				border: none;
			}
			a#abortbutton, a#showworkingclose {
				float: left;
				margin-left: 10px;
				padding: 10px;
				font-size: 12px;
				font-family: sans-serif,"Arial";
				text-decoration: none;
				background-color: #cd1212;
				color: #fff;
				border: none;
			}
*/
			#backwpup-page samp {
				font-family: Consolas, Monaco, monospace;
			}
			.progressbar {
				margin-top: 20px;
				height: auto;
				background: #f6f6f6 url('<?php echo BackWPup::get_plugin_data( 'URL' );?>/assets/images/progressbarhg.jpg');
			}

			#lastmsg, #onstep, #lasterrormsg {
				text-align: center;
				margin-bottom: 20px;
			}
			#backwpup-page #lastmsg samp,
			#backwpup-page #onstep samp,
			#backwpup-page #lasterrormsg samp {
				font-family: "Open Sans", sans-serif;
			}
			.bwpu-progress {
				background-color: #1d94cf;
				color: #fff;
				padding: 5px 0;
				text-align: center;
			}
			#progresssteps {
				background-color: #007fb6;
			}

			.row-actions .lastlog {
				display: none;
			}

			@media screen and (max-width: 782px) {
				.column-type, .column-dest {
					display: none;
				}
				.row-actions .lastlog {
					display: inline-block;
				}
				.last-action-links {
					display: none;
				}
			}
		</style>
		<?php
	}

	/**
	 *
	 */
	public static function admin_print_scripts() {

		wp_enqueue_script( 'backwpupgeneral' );
	}

	/**
	 *
	 */
	public static function page() {

		echo '<div class="wrap" id="backwpup-page">';
		echo '<h2><span id="backwpup-page-icon">&nbsp;</span>' . esc_html( sprintf( __( '%s Jobs', 'backwpup' ), BackWPup::get_plugin_data( 'name' ) ) ) . '&nbsp;<a href="' . wp_nonce_url( network_admin_url( 'admin.php' ) . '?page=backwpupeditjob', 'edit-job' ) . '" class="add-new-h2">' . esc_html__( 'Add new', 'backwpup' ) . '</a></h2>';
		BackWPup_Admin::display_messages();
		$job_object = BackWPup_Job::get_working_data();
		if ( current_user_can( 'backwpup_jobs_start' ) && is_object( $job_object )  ) {

				//read existing logfile
				$logfiledata = file_get_contents( $job_object->logfile );
				preg_match( '/<body[^>]*>/si', $logfiledata, $match );
				if ( ! empty( $match[ 0 ] ) )
					$startpos = strpos( $logfiledata, $match[ 0 ] ) + strlen( $match[ 0 ] );
				else
					$startpos = 0;
				$endpos = stripos( $logfiledata, '</body>' );
				if ( empty( $endpos ) )
					$endpos = strlen( $logfiledata );
				$length = strlen( $logfiledata ) - ( strlen( $logfiledata ) - $endpos ) - $startpos;

				?>
			<div id="runningjob">
				<div id="runniginfos">
					<h2 id="runningtitle"><?php sprintf( __('Job currently running: %s','backwpup'), $job_object->job[ 'name' ] ); ?></h2>
					<span id="warningsid"><?php _e( 'Warnings:', 'backwpup' ); ?> <span id="warnings"><?php echo $job_object->warnings; ?></span></span>
					<span id="errorid"><?php _e( 'Errors:', 'backwpup' ); ?> <span id="errors"><?php echo $job_object->errors; ?></span></span>
					<div class="infobuttons"><a href="#TB_inline?height=440&width=630&inlineId=tb-showworking" id="showworkingbutton" class="thickbox button button-primary button-primary-bwp" title="<?php _e( 'Log of running job', 'backwpup'); ?>"><?php _e( 'Display working log', 'backwpup' ); ?></a>
					<a href="<?php echo wp_nonce_url( network_admin_url( 'admin.php' ) . '?page=backwpupjobs&action=abort', 'abort-job' ); ?>" id="abortbutton" class="backwpup-fancybox button button-bwp"><?php _e( 'Abort', 'backwpup' ); ?></a>
					<a href="#" id="showworkingclose" title="<?php _e( 'Close working screen', 'backwpup'); ?>" class="button button-bwp" style="display:none" ><?php _e( 'close', 'backwpup' ); ?></a></div>
				</div>
				<input type="hidden" name="logpos" id="logpos" value="<?php echo strlen( $logfiledata ); ?>">
				<div id="lasterrormsg"></div>
				<div class="progressbar"><div id="progressstep" class="bwpu-progress" style="width:<?php echo $job_object->step_percent; ?>%;"><?php echo  $job_object->step_percent; ?>%</div></div>
				<div id="onstep"><samp><?php echo $job_object->steps_data[ $job_object->step_working ][ 'NAME' ]; ?></samp></div>
				<div class="progressbar"><div id="progresssteps" class="bwpu-progress" style="width:<?php echo $job_object->substep_percent; ?>%;"><?php echo $job_object->substep_percent; ?>%</div></div>
				<div id="lastmsg"><?php echo $job_object->lastmsg; ?></div>
				<div id="tb-showworking" style="display:none;">
					<div id="showworking"><?php echo substr( $logfiledata, $startpos, $length ); ?></div>
				</div>
			</div>
		<?php }

		//display jos Table
		?>
		<form id="posts-filter" action="" method="get">
		<input type="hidden" name="page" value="backwpupjobs" />
		<?php
		echo wp_nonce_field( 'backwpup_ajax_nonce', 'backwpupajaxnonce', FALSE );
		self::$listtable->display();
		?>
		<div id="ajax-response"></div>
		</form>
		</div>
		<?php

		if ( ! empty( $job_object->logfile ) ) { ?>
        <script type="text/javascript">
            //<![CDATA[
            jQuery(document).ready(function ($) {
                backwpup_show_working = function () {
                    $.ajax({
                        type: 'GET',
                        url: ajaxurl,
                        cache: false,
                        data:{
                            action: 'backwpup_working',
                            logpos: $('#logpos').val(),
							logfile: '<?php echo basename( $job_object->logfile );?>',
                            _ajax_nonce: '<?php echo wp_create_nonce( 'backwpupworking_ajax_nonce' );?>'
                        },
                        dataType: 'json',
                        success:function (rundata) {
							if ( rundata == 0 ) {
								$("#abortbutton").remove();
								$("#backwpup-adminbar-running").remove();
								$(".job-run").hide();
								$("#message").hide();
								$(".job-normal").show();
								$('#showworkingclose').show();
							}
							if (0 < rundata.log_pos) {
								$('#logpos').val(rundata.log_pos);
							}
                            if ('' != rundata.log_text) {
                                $('#showworking').append(rundata.log_text);
								$('#TB_ajaxContent').scrollTop(rundata.log_pos * 15);
                            }
                            if (0 < rundata.error_count) {
                                $('#errors').replaceWith('<span id="errors">' + rundata.error_count + '</span>');
                            }
                            if (0 < rundata.warning_count) {
                                $('#warnings').replaceWith('<span id="warnings">' + rundata.warning_count + '</span>');
                            }
                            if (0 < rundata.step_percent) {
                                $('#progressstep').replaceWith('<div id="progressstep" class="bwpu-progress">' + rundata.step_percent + '%</div>');
                                $('#progressstep').css('width', parseFloat(rundata.step_percent) + '%');
                            }
                            if (0 < rundata.sub_step_percent) {
                                $('#progresssteps').replaceWith('<div id="progresssteps" class="bwpu-progress">' + rundata.sub_step_percent + '%</div>');
                                $('#progresssteps').css('width', parseFloat(rundata.sub_step_percent) + '%');
                            }
                            if (0 < rundata.running_time) {
                                $('#runtime').replaceWith('<span id="runtime">' + rundata.running_time + '</span>');
                            }
                            if ( '' != rundata.onstep ) {
                                $('#onstep').replaceWith('<div id="onstep"><samp>' + rundata.on_step + '</samp></div>');
                            }
                            if ( '' != rundata.last_msg ) {
                                $('#lastmsg').replaceWith('<div id="lastmsg">' + rundata.last_msg + '</div>');
                            }
							if ( '' != rundata.last_error_msg ) {
							    $('#lasterrormsg').replaceWith('<div id="lasterrormsg">' + rundata.last_error_msg + '</div>');
						    }
                            if ( rundata.job_done == 1 ) {
                                $("#abortbutton").remove();
                                $("#backwpup-adminbar-running").remove();
								$(".job-run").hide();
                                $("#message").hide();
                                $(".job-normal").show();
                                $('#showworkingclose').show();
                            } else {
                            	setTimeout('backwpup_show_working()', 750);
                            }
                        },
						error:function ( ) {
							setTimeout('backwpup_show_working()', 750);
						}
                    });
                };
                backwpup_show_working();
                $('#showworkingclose').click( function() {
                    $("#runningjob").hide( 'slow' );
                    return false;
                });
            });
            //]]>
        </script>
		<?php }
	}


	/**
	 *
	 * Function to generate json data
	 *
	 */
	public static function ajax_working() {

		check_ajax_referer( 'backwpupworking_ajax_nonce' );

		$logfile = isset( $_GET[ 'logfile' ] ) ? get_site_option( 'backwpup_cfg_logfolder' ) . trim( $_GET[ 'logfile' ] ) : NULL;
		$logpos  = isset( $_GET[ 'logpos' ] ) ? (int)$_GET[ 'logpos' ] : 0;

		//check if logfile renamed
		if ( file_exists( $logfile . '.gz' ) )
			$logfile .= '.gz';

		if ( ! is_readable( $logfile ) )
			die( '0' );

		$job_object = BackWPup_Job::get_working_data();
		$done = 0;
		if ( is_object( $job_object ) ) {
			$warnings        = $job_object->warnings;
			$errors          = $job_object->errors;
			$step_percent    = $job_object->step_percent;
			$substep_percent = $job_object->substep_percent;
			$runtime 		 = current_time( 'timestamp' ) - $job_object->start_time;
			$onstep			 = $job_object->steps_data[ $job_object->step_working ][ 'NAME' ];
			$lastmsg		 = $job_object->lastmsg;
			$lasterrormsg    = $job_object->lasterrormsg;
		} else {
			$logheader       = BackWPup_Job::read_logheader( $logfile );
			$warnings        = $logheader[ 'warnings' ];
			$runtime         = $logheader[ 'runtime' ];
			$errors          = $logheader[ 'errors' ];
			$step_percent    = 100;
			$substep_percent = 100;
			$onstep			 = '<div class="backwpup-message backwpup-info"><p>' . __( 'Job completed' , 'backwpup' ) . '</p></div>';
			if ( $errors > 0 )
				$lastmsg		 = '<div class="error"><p>' . __( 'ERROR:', 'backwpup' ) . ' ' .  sprintf( __( 'Job has ended with errors in %s seconds. You must resolve the errors for correct execution.', 'backwpup' ), $logheader[ 'runtime' ] ) . '</p></div>';
			elseif ( $warnings > 0 )
				$lastmsg		 = '<div class="backwpup-message backwpup-warning"><p>' . __( 'WARNING:', 'backwpup' ) . ' ' .  sprintf( __( 'Job has done with warnings in %s seconds. Please resolve them for correct execution.', 'backwpup' ), $logheader[ 'runtime' ] ) . '</p></div>';
			else
				$lastmsg		 = '<div class="updated"><p>' .  sprintf( __( 'Job done in %s seconds.', 'backwpup' ), $logheader[ 'runtime' ] ) . '</p></div>';
			$lasterrormsg    = '';
			$done            = 1;
		}

		if ( '.gz' == substr( $logfile, -3 ) )
			$logfiledata = file_get_contents( 'compress.zlib://' . $logfile, FALSE, NULL, $logpos );
		else
			$logfiledata = file_get_contents( $logfile, FALSE, NULL, $logpos );

		preg_match( '/<body[^>]*>/si', $logfiledata, $match );
		if ( ! empty( $match[ 0 ] ) )
			$startpos = strpos( $logfiledata, $match[ 0 ] ) + strlen( $match[ 0 ] );
		else
			$startpos = 0;

		$endpos = stripos( $logfiledata, '</body>' );
		if ( FALSE === $endpos )
			$endpos = strlen( $logfiledata );

		$length = strlen( $logfiledata ) - ( strlen( $logfiledata ) - $endpos ) - $startpos;

		@header( 'Content-Type: application/json; charset=' . get_option( 'blog_charset' ), TRUE );
		$json = json_encode( array(
							   'log_pos'         => strlen( $logfiledata ) + $logpos,
							   'log_text'        => substr( $logfiledata, $startpos, $length ),
							   'warning_count'   => $warnings,
							   'error_count'     => $errors,
							   'running_time'	 => $runtime,
							   'step_percent'    => $step_percent,
							   'on_step'		 => $onstep,
							   'last_msg'		 => $lastmsg,
							   'last_error_msg'	 => $lasterrormsg,
							   'sub_step_percent'=> $substep_percent,
							   'job_done'		 => $done
						  ) );
		die( $json );
	}

}

