    <?php
    /**
     * colour tags: colours DONE/TODO/ONGOING/OP strings
     * 
     * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
     * @author     Cipi Bad <cipibad@gmail.com>
     * @author     Christopher Smith <chris@jalakai.co.uk>
     */
     
    // must be run within DokuWiki
    if(!defined('DOKU_INC')) die();
     
    if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
    require_once DOKU_PLUGIN.'syntax.php';
     
    /**
     * All DokuWiki plugins to extend the parser/rendering mechanism
     * need to inherit from this class
     */
    class syntax_plugin_colourTags extends DokuWiki_Syntax_Plugin {
     
        function getInfo() {
            return array('author' => 'Cipi Bad',
                         'email'  => 'cipibad@gmail.com',
                         'date'   => '2013-05-10',
                         'name'   => 'colourTags',
                         'desc'   => 'colours DONE/TODO/ONGOIND/OP strings',
                         'url'    => 'http://www.dokuwiki.org/devel:syntax_plugins');
        }
     
        function getType() { return 'substition'; }
        function getSort() { return 32; }
     
        function connectTo($mode) {
            $this->Lexer->addSpecialPattern('DONE|TODO|ONGOING|OP',$mode,'plugin_colourTags');
        }
     
        function handle($match, $state, $pos, &$handler) {
	    if ("DONE" == $match) { $color = "color:green"; }
	    if ("TODO" == $match) { $color = "color:OrangeRed"; }
	    if ("ONGOING" == $match) { $color = "color:blue"; }
	    if ("OP" == $match) { $color = "color:GoldenRod"; }
	    $match = '<span style="font-weight: bold;' . $color . '">' . $match . '</span>';
            return array($match, $state, $pos);
        }
     
        function render($mode, &$renderer, $data) {
        // $data is what the function handle return'ed.
            if($mode == 'xhtml'){
                $renderer->doc .= $data[0];
                return true;
            }
            return false;
        }
    }

